/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.text;

import icyllis.modernui.text.MeasuredParagraph;
import icyllis.modernui.text.TextDirectionHeuristic;
import icyllis.modernui.text.TextPaint;
import icyllis.modernui.text.TextUtils;
import java.util.ArrayList;
import javax.annotation.Nonnull;

public class PrecomputedText {
    public static ParagraphInfo[] createMeasuredParagraphs(@Nonnull TextPaint paint, @Nonnull CharSequence text, int start, int end, @Nonnull TextDirectionHeuristic dir) {
        ArrayList<ParagraphInfo> list = new ArrayList<ParagraphInfo>();
        int paraStart = start;
        while (paraStart < end) {
            int paraEnd = TextUtils.indexOf(text, '\n', paraStart, end);
            paraEnd = paraEnd < 0 ? end : ++paraEnd;
            ParagraphInfo info = new ParagraphInfo(paraEnd, MeasuredParagraph.buildForStaticLayout(paint, text, paraStart, paraEnd, dir, null));
            if (info.measured.getTextLength() > 0) {
                list.add(info);
            }
            paraStart = paraEnd;
        }
        return list.toArray(new ParagraphInfo[0]);
    }

    public static class ParagraphInfo {
        public final int paragraphEnd;
        @Nonnull
        public final MeasuredParagraph measured;

        public ParagraphInfo(int paraEnd, @Nonnull MeasuredParagraph measured) {
            this.paragraphEnd = paraEnd;
            this.measured = measured;
        }
    }
}

